clear

% set parameters
beta  = 0.99;
gamma = 1;
theta = 1;
xi_s   = 0.1;
s_c   = 0.8;
pi    = 1;
rho   = 0.95;
psi=0.85;

% derived parameters
omega=(1+psi/gamma)*s_c;
P_m=beta/(pi-beta*rho);
P_s=beta/pi;

% define input matrices
A0=zeros(4,4);
B0=zeros(4,4);

A0(1,:)=[1+xi_s*beta*s_c*(1+psi/gamma)/P_s xi_s*beta*P_m/P_s -1*xi_s*P_m/P_s beta*xi_s]; 
A0(2,:)=[1 -1*theta*xi_s*beta theta*xi_s*(1+beta) 0]; %check
A0(3,:)=[0 0 1 0]; %check
A0(4,:)=[0 0 0 1]; %check

B0(1,:)=[1 0 0 xi_s];
B0(2,:)=[1 0 xi_s*theta 0]; %check
B0(3,:)=[0 1 0 0]; %check
B0(4,:)=[-1*s_c*(1+psi/gamma)/P_s -1*P_m/P_s P_m/(beta*P_s) 1/beta];%check

n_k = 2;

% get decision rule matrices
getDecision(A0,B0,n_k);